// AvsdApiTestDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AvsdApiTest.h"
#include "AvsdApiTestDlg.h"
#include "AvsdApiTestdlg.h"
#include "avsdapi.h"

#include <afxtempl.h>
#include <atlbase.h>
#include ".\avsdapitestdlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAvsdApiTestDlg dialog

CAvsdApiTestDlg::CAvsdApiTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAvsdApiTestDlg::IDD, pParent)
	, m_sPlugPort(_T(""))
	, m_sSettings(_T(""))
	, m_sPath(_T(""))
	, m_sPort1(_T(""))
	, m_sPort2(_T(""))
	, m_sByte(_T(""))
	, m_sString(_T(""))
	, m_sEventsPort(_T(""))
	, m_sReadCount(_T(""))
	, m_sStringCOM(_T(""))
{
	//{{AFX_DATA_INIT(CAvsdApiTestDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_hDataEvent = NULL;
	m_hSettingsEvent = NULL;
	m_hFlowEvent = NULL;
	m_hStateEvent = NULL;

	for (int i=0; i<256; i++)
		handles[i] = NULL;
}

CAvsdApiTestDlg::~CAvsdApiTestDlg()
{
	for (int i=0; i<256; i++)
	{
		if (handles[i] != NULL)
		{
			::CloseHandle(handles[i]);
			handles[i] = NULL;
		}
	}
}

void CAvsdApiTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAvsdApiTestDlg)
	// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
	DDX_Text(pDX, IDC_EDT_PLUG_PORT, m_sPlugPort);
	DDV_MaxChars(pDX, m_sPlugPort, 3);

	DDX_Control(pDX, IDC_CH_CS_RTS, m_arrChCS[0]);
	DDX_Control(pDX, IDC_CH_CS_CTS, m_arrChCS[1]);
	DDX_Control(pDX, IDC_CH_CS_DTR, m_arrChCS[2]);
	DDX_Control(pDX, IDC_CH_CS_DSR, m_arrChCS[3]);
	DDX_Control(pDX, IDC_CH_CS_RI, m_arrChCS[4]);
	DDX_Control(pDX, IDC_CH_CS_CD, m_arrChCS[5]);

	DDX_Control(pDX, IDC_CH_EVENTS_STATE, m_arrChEvents[0]);
	DDX_Control(pDX, IDC_CH_EVENTS_SETTINGS, m_arrChEvents[1]);
	DDX_Control(pDX, IDC_CH_EVENTS_BUFFER, m_arrChEvents[2]);
	DDX_Control(pDX, IDC_CH_EVENTS_CSIGNALS, m_arrChEvents[3]);

	DDX_Text(pDX, IDC_EDT_SETTINGS, m_sSettings);
	DDX_Text(pDX, IDC_PATH, m_sPath);
	DDX_Text(pDX, IDC_EDT_PORT1, m_sPort1);
	DDX_Text(pDX, IDC_EDT_PORT2, m_sPort2);
	DDX_Text(pDX, IDC_EDT_BYTE, m_sByte);
	DDX_Text(pDX, IDC_EDT_STRING, m_sString);
	DDX_Text(pDX, IDC_EDT_EVENTS_PORT, m_sEventsPort);
	DDX_Control(pDX, IDC_EDT_EVENTS_LOG, m_edtEventsLog);
	DDX_Text(pDX, IDC_EDT_READ_COUNT, m_sReadCount);
	DDX_Control(pDX, IDC_COMBO1, comboLog);
	DDX_Text(pDX, IDC_EDT_STRING2, m_sStringCOM);
}

BEGIN_MESSAGE_MAP(CAvsdApiTestDlg, CDialog)
	//{{AFX_MSG_MAP(CAvsdApiTestDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON2, OnEventsApply)
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_PLUG, OnBnClickedBtnPlug)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BTN_UNPLUG, OnBnClickedBtnUnplug)
	ON_BN_CLICKED(IDC_BTN_IS_PLUGGED, OnBnClickedBtnIsPlugged)
	ON_BN_CLICKED(IDC_BTN_IS_OPENED, OnBnClickedBtnIsOpened)
	ON_BN_CLICKED(IDC_BTN_SIGNALS_GET, OnBnClickedBtnSignalsGet)
	ON_BN_CLICKED(IDC_BTN_SIGNALS_SET, OnBnClickedBtnSignalsSet)
	ON_BN_CLICKED(IDC_BTN_SETTINGS_GET, OnBnClickedBtnSettingsGet)
	ON_BN_CLICKED(IDC_BTN_INSTALL, OnBnClickedBtnInstall)
	ON_BN_CLICKED(IDC_BTN_UNINSTALL, OnBnClickedBtnUninstall)
	ON_BN_CLICKED(IDC_BTN_PORTBUF_LEN, OnBnClickedBtnPortbufLen)
	ON_BN_CLICKED(IDC_BTN_CONNECT, OnBnClickedBtnConnect)
	ON_BN_CLICKED(IDC_BTN_DISCONNECT, OnBnClickedBtnDisconnect)
	ON_BN_CLICKED(IDC_BTN_GETCONNECT, OnBnClickedBtnGetconnect)
	ON_BN_CLICKED(IDC_BTN_READ_BYTE, OnBnClickedBtnReadByte)
	ON_BN_CLICKED(IDC_BTN_WRITE_BYTE, OnBnClickedBtnWriteByte)
	ON_BN_CLICKED(IDC_BTN_READ_STR, OnBnClickedBtnReadStr)
	ON_BN_CLICKED(IDC_BTN_WRITE_STR, OnBnClickedBtnWriteStr)
	ON_BN_CLICKED(IDC_BTN_EVENTSLOG_CLEAR, OnBnClickedBtnEventslogClear)
	ON_BN_CLICKED(IDC_BTN_ABOUT, OnBnClickedBtnAbout)
	ON_BN_CLICKED(IDC_BUTTON3, OnOpenPort)
	ON_BN_CLICKED(IDC_BUTTON4, OnCloseCOM)
	ON_BN_CLICKED(IDC_BUTTON6, OnWriteCOM)
	ON_BN_CLICKED(IDC_BUTTON5, OnReadCOM)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAvsdApiTestDlg message handlers

void CAvsdApiTestDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAvsdApiTestDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAvsdApiTestDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

BOOL CAvsdApiTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	m_sPlugPort = _T("3");
	m_sEventsPort = _T("3");
	m_sPort1 = _T("3");
	m_sPort2 = _T("4");
	m_sByte = _T("56");
	m_sString = _T("abcdEFJ");
	m_sReadCount = _T("10");
	m_sPath = _T("");
	UpdateData(false);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAvsdApiTestDlg::OnClose()
{
	// TODO: Add your message handler code here and/or call default
	bStopDataEventThread = TRUE;
	bStopSettingsEventThread = TRUE;
	bStopFlowEventThread = TRUE;
	bStopStateEventThread = TRUE;

	Sleep(500);

	CDialog::OnClose();
}

void CAvsdApiTestDlg::LoggingLastError(LPCTSTR lpszString, DWORD dwError)
{
	LPVOID lpMsgBuf;
	
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		dwError,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL);

	CString sErr;
	sErr.Format("%s %s", lpszString, lpMsgBuf);

	LocalFree(lpMsgBuf);

	Logging(sErr);
}

// Shows a message box with error.
// Descr   - error description
// dwError - Win32 error code
void CAvsdApiTestDlg::ShowError(const char *Descr, DWORD dwError)
{
	LPVOID lpMsgBuf;
	
	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | 
		FORMAT_MESSAGE_FROM_SYSTEM | 
		FORMAT_MESSAGE_IGNORE_INSERTS,
		NULL,
		dwError,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL);


	CString sErr;
	sErr.Format("%s Error: %s",Descr,lpMsgBuf);

	LocalFree(lpMsgBuf);

	MessageBox(sErr, 0, MB_OK | MB_ICONERROR);
}

// Returns the port number entered in the port management section
int CAvsdApiTestDlg::GetPlugPort()
{
	UpdateData();
	int nPort = atoi(m_sPlugPort);
	return nPort;
}

// Returns the first port number entered in the Connect/Disconnect section
int CAvsdApiTestDlg::GetPort1()
{
	UpdateData();
	int nPort = atoi(m_sPort1);
	return nPort;
}

// Returns the second port number entered in the Connect/Disconnect section
int CAvsdApiTestDlg::GetPort2()
{
	UpdateData();
	int nPort = atoi(m_sPort2);
	return nPort;
}

// Returns the port number entered in the Events section
int CAvsdApiTestDlg::GetEventsPort()
{
	UpdateData();
	int nPort = atoi(m_sEventsPort);
	return nPort;
}

// Returns the number of bytes to read entered in the 
// "Port buffer functions" section
long CAvsdApiTestDlg::GetReadCount()
{
	UpdateData();
	return atoi(m_sReadCount);
}

// Plug button clicked
void CAvsdApiTestDlg::OnBnClickedBtnPlug()
{
	// Create new virtual port
	int port = GetPlugPort();
	CString s;
	if (avsdPluginPort(port, FALSE))
	{
        s.Format("COM%d is plugged SUCCEEDED", port);
		Logging(s);
	}
	else
	{
        s.Format("COM%d plugging FAILED", port);
		Logging(s);
	}
}

// Unplug button clicked
void CAvsdApiTestDlg::OnBnClickedBtnUnplug()
{
	// Remove virtual port
	int port = GetPlugPort();
	CString s;
	if (avsdUnplugPort(port))
	{
        s.Format("COM%d is unplugged SUCCEEDED.", port);
		Logging(s);
	}
	else
	{
        s.Format("COM%d unplugging FAILED.", port);
		Logging(s);
	}

}

// Is plugged button clicked
void CAvsdApiTestDlg::OnBnClickedBtnIsPlugged()
{
	int nPort = GetPlugPort();
	BOOL bRes;
	CString info;

	// Get the port Plugged/Unplugged state
	if( !avsdIsPortPluggedIn(nPort, &bRes) )
	{
		DWORD dwError = ::GetLastError();
		info.Format("avsdIsPortPluggedIn() for COM%d FAILED:", nPort);
		LoggingLastError(info, dwError);
		ShowError("", dwError);
		return;
	}

	CString s, sMsg;
	if(bRes != VARIANT_FALSE)
	{
		s = "plugged";
		info.Format("COM%d is plugged", nPort);
		Logging(info);
	}
	else
	{
		s = "unplugged";
		info.Format("COM%d is unplugged", nPort);
		Logging(info);
	}
	sMsg.Format("Port COM%i is %s", nPort, s);
	MessageBox(sMsg);
}

// Is opened button clicked
void CAvsdApiTestDlg::OnBnClickedBtnIsOpened()
{
	int nPort = GetPlugPort();
	BOOL bRes;
	CString info;

	// Get the port opened/closed state
	if( !avsdIsPortOpened(nPort, &bRes) )
	{
		DWORD dwError = ::GetLastError();
		info.Format("avsdIsPortOpened() for COM%d FAILED:", nPort);
		LoggingLastError(info, dwError);
		ShowError("Can't get port state.", dwError);
		return;
	}

	CString s, sMsg;
	if(bRes != VARIANT_FALSE)
	{
		s = "opened";
		info.Format("COM%d is opened", nPort);
		Logging(info);
	}
	else
	{
		s = "closed";
		info.Format("COM%d is not opened", nPort);
		Logging(info);
	}
	sMsg.Format("Port COM%i is %s", nPort, s);
	MessageBox(sMsg);
}

// Get signals button clicked
void CAvsdApiTestDlg::OnBnClickedBtnSignalsGet()
{
	DWORD dwS;
	int port = GetPlugPort();
	CString s;

	// Read port signals states
	if( !avsdGetControlSignals(port, &dwS))
	{
		DWORD dwError = ::GetLastError();
		s.Format("Can't get signals for COM%d:", port);
		LoggingLastError(s, dwError);
		ShowError("Can't get signals.", dwError);
		return;
	}

	s.Format("Signals get for COM%d: SUCCEEDED", port);
	Logging(s);

	// Uncheck checkboxes
	for(int i = 0; i < NUM_CH_CS; ++i) m_arrChCS[i].SetCheck(BST_UNCHECKED);

	// Check the checkboxes when corresponding signal is set
	if(dwS & AVSD_SIGNAL_RTS)	m_arrChCS[0].SetCheck(BST_CHECKED);
	if(dwS & AVSD_SIGNAL_CTS)	m_arrChCS[1].SetCheck(BST_CHECKED);
	if(dwS & AVSD_SIGNAL_DTR)	m_arrChCS[2].SetCheck(BST_CHECKED);
	if(dwS & AVSD_SIGNAL_DSR)	m_arrChCS[3].SetCheck(BST_CHECKED);
	if(dwS & AVSD_SIGNAL_RI)	m_arrChCS[4].SetCheck(BST_CHECKED);
	if(dwS & AVSD_SIGNAL_CD)	m_arrChCS[5].SetCheck(BST_CHECKED);
}

// Set signals button clicked
void CAvsdApiTestDlg::OnBnClickedBtnSignalsSet()
{
	int port = GetPlugPort();
	CString s;
	DWORD dwS = 0;

	// Get the states of checkboxes and convert them to signals mask
	if(m_arrChCS[0].GetCheck() == BST_CHECKED)	dwS |= AVSD_SIGNAL_RTS;
	if(m_arrChCS[1].GetCheck() == BST_CHECKED)	dwS |= AVSD_SIGNAL_CTS;
	if(m_arrChCS[2].GetCheck() == BST_CHECKED)	dwS |= AVSD_SIGNAL_DTR;
	if(m_arrChCS[3].GetCheck() == BST_CHECKED)	dwS |= AVSD_SIGNAL_DSR;
	if(m_arrChCS[4].GetCheck() == BST_CHECKED)	dwS |= AVSD_SIGNAL_RI;
	if(m_arrChCS[5].GetCheck() == BST_CHECKED)	dwS |= AVSD_SIGNAL_CD;

	// Set signals for port
	if( !avsdSetControlSignals(port, dwS) )
	{
		DWORD dwError = ::GetLastError();
		s.Format("Can't set signals for COM%d", port);
		LoggingLastError(s, dwError);
		ShowError("Can't set signals.", dwError);
	}

	s.Format("Signals set for COM%d: SUCCEEDED", port);
	Logging(s);
}

// Print port settings to CString
BOOL CAvsdApiTestDlg::PortSettingsToStr(PAVSD_PORT_SETTINGS pPortSettings, CString* ps)
{
	CString s, sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("BaudRate"), pPortSettings->dwBaudRate);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("ByteSize"), pPortSettings->ByteSize);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("Parity"), pPortSettings->Parity);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("StopBits"), pPortSettings->StopBits);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("XonChar"), pPortSettings->cXonChar);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("XoffChar"), pPortSettings->cXoffChar);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("ErrorChar"), pPortSettings->cErrorChar);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("EofChar"), pPortSettings->cEofChar);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("EvtChar"), pPortSettings->cEvtChar);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("XonLim"), pPortSettings->wXonLim);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("XoffLim"), pPortSettings->wXoffLim);
	*ps += sTmp;

	sTmp.Format(_T("%s: %d\r\n"), _T("FlowControl"), pPortSettings->FlowControl);
	*ps += sTmp;

	return TRUE;
}

// Get settings button clicked
void CAvsdApiTestDlg::OnBnClickedBtnSettingsGet()
{
	AVSD_PORT_SETTINGS PortSettings;
	int port = GetPlugPort();
	CString s;

	// Get port settings
	if( !avsdGetSettings(port, &PortSettings) )
	{
		DWORD dwError = ::GetLastError();
		s.Format("Cannot get settings of COM%d", port);
		LoggingLastError(s, dwError);

		ShowError("Can't get port settings.", dwError);
		return;
	}

	s.Format("getting settings for COM%d SUCCEEDED", port);
	Logging(s);

	m_sSettings = "";

	// Print port settings
	PortSettingsToStr(&PortSettings, &m_sSettings);

	UpdateData(false);
}

// Install button clicked
void CAvsdApiTestDlg::OnBnClickedBtnInstall()
{
	UpdateData();

	CString s = "avsdInstallDriver() return ";

	// Install AVSD drivers
	if( !avsdInstallDrivers((PCHAR)LPCTSTR(m_sPath)) )
	{
		DWORD dwError = ::GetLastError();
		
		s += "ERROR: ";
		switch (dwError)
		{
		case ERR_AVSD_TRIAL_EXPIRED:
			Logging("avsdInstallDriver() FAILED: Your trial has expired.");
			break;

		case ERR_AVSD_REBOOT_REQUIRED:
			Logging("avsdInstallDriver() FAILED: Reboot required.");
			ShowError("Reboot Required !!!", 1072); return;
			break;

		case ERR_AVSD_WRONG_PATH:
			Logging("avsdInstallDriver() FAILED: Wrong Path.");
			MessageBox("Wrong Path !!!");return;
			break;

		case ERROR_INVALID_PARAMETER:
			Logging("avsdInstallDriver() FAILED: Invalid parameter.");
			break;

		default:
			LoggingLastError("avsdInstallDriver() FAILED:", dwError);
		}

		ShowError("Can't install drivers.", dwError);
	}
	else
	{
		Logging("avsdInstallDriver() return SUCCESS");
	}
}

// Uninstall button clicked
void CAvsdApiTestDlg::OnBnClickedBtnUninstall()
{
	CString s = "avsdUninstallDrivers() return ";
	// Uninstall AVSD drivers
	if( !avsdUninstallDrivers() )
	{
		DWORD dwError = ::GetLastError();
		ShowError("Can't uninstall drivers.", dwError);
		LoggingLastError("avsdUninstallDrivers() FAILED:", dwError);
	}
	else
	{
        Logging("avsdUninstallDrivers() return SUCCESS");
	}
}

void CAvsdApiTestDlg::Logging(LPCTSTR lpszString)
{
	int index =	comboLog.InsertString(0, lpszString);
	comboLog.SetCurSel(index);
}

// Get data len button clicked
void CAvsdApiTestDlg::OnBnClickedBtnPortbufLen()
{
	DWORD dwPort = GetPlugPort();
	DWORD dwBytes;
	CString info;

	// Get the number of bytes in port buffer
	if( !avsdGetNumBytesInBuffer(dwPort, &dwBytes) )
	{
		DWORD dwError = ::GetLastError();
		info.Format("Can't get number of bytes in COM%d buffer:", dwPort);
		LoggingLastError(info, dwError);
		ShowError("Can't get number of bytes.", dwError);
		return;
	}

	CString s;
	s.Format("%d bytes in buffer of the port COM%d", dwBytes, dwPort);
	Logging(s);
	MessageBox(s);
}

// Connect button clicked
void CAvsdApiTestDlg::OnBnClickedBtnConnect()
{
	// Connect specified ports
	if( !avsdConnectPorts(GetPort1(), GetPort2()) )
	{
		DWORD dwError = ::GetLastError();
		ShowError("Can't connect ports.", dwError);
		CString s;
		s.Format("COM%d not connected to COM%d:", GetPort1(), GetPort2());
		LoggingLastError(s, dwError);
	}
	else
	{
		CString s;
		s.Format("COM%d connected to COM%d", GetPort1(), GetPort2());
        Logging(s);
	}
}

// Disconnect button clicked
void CAvsdApiTestDlg::OnBnClickedBtnDisconnect()
{
	// Disconnect specified ports
	int port1 = GetPort1();
	int port2 = GetPort2();
	CString s;
	if( !avsdDisconnectPorts(port1, port2) )
	{
		DWORD dwError = ::GetLastError();
        s.Format("COM%d and COM%d was disconnected FAILED", port1, port2);
        LoggingLastError(s, dwError);
		ShowError("Can't disconnect ports.", dwError);
	}
	else
	{
		s.Format("COM%d and COM%d was disconnected SUCCEEDED", port1, port2);
		Logging(s);
	}
}

// Get connected port button clicked
void CAvsdApiTestDlg::OnBnClickedBtnGetconnect()
{
	DWORD dwPort1 = GetPort1();
	DWORD dwPort2;
	CString info;

	// Get the port connected to dwPort1
	if( !avsdGetConnectedPort(dwPort1, &dwPort2) )
	{
		DWORD dwError = ::GetLastError();
		info.Format("avsdGetConnectedPort() for COM%d FAILED:", dwPort1);
		LoggingLastError(info, dwError);

		ShowError("Can't get connected port.", dwError);
		return;
	}

	CString s;
	if(dwPort2 == 0xFFFFFFFF)
	{
		s.Format("Port COM%d has no connected ports", dwPort1);
	}
	else
	{
		s.Format("Port COM%d is connected to COM%d", dwPort2, dwPort1);
	}
	Logging(s);
	MessageBox(s);
}

// Read byte button clicked
void CAvsdApiTestDlg::OnBnClickedBtnReadByte()
{
	CHAR bt;

	int port = GetPlugPort();
	CString s;

	// Read one byte from specified port buffer
	if( !avsdReadCharFromPortBuffer(port, &bt) )
	{
		DWORD dwError = ::GetLastError();
		s.Format("Can't read from COM%d port buffer:", port);
		LoggingLastError(s, dwError);
		ShowError("Can't read from port buffer.", dwError);
		return;
	}

	s.Format("read from COM%d port buffer SUCCEEDED", port);
	Logging(s);
	
	// Print the byte that was read
	m_sByte.Format("%d", bt);

	UpdateData(false);
}

// Write byte button clicked
void CAvsdApiTestDlg::OnBnClickedBtnWriteByte()
{
	UpdateData();
	BYTE bt = atoi(m_sByte); // Get the byte to write
	int port = GetPlugPort();
	CString s;

	// Write byte to specified port
	if( !avsdWriteCharToPortBuffer(port, bt) )
	{
		DWORD dwError = ::GetLastError();
		s.Format("Can't write to COM%d port buffer:", port);
		LoggingLastError(s, dwError);
		ShowError("Can't write to port buffer.", dwError);
	}

	s.Format("Write to COM%d port buffer SUCCEEDED", port);
	Logging(s);
}

// Read str button clicked
void CAvsdApiTestDlg::OnBnClickedBtnReadStr()
{
	DWORD dwCount = GetReadCount();
	BYTE *bData = new BYTE[dwCount+1];
	DWORD dwRead;
	CString info;
	int port = GetPlugPort();

	// Read dwCount bytes from specified port buffer
	if( !avsdReadFromPortBuffer(port, bData, dwCount, &dwRead) )
	{
		DWORD dwError = ::GetLastError();
		info.Format("Can't read from COM%d port buffer:", port);
		LoggingLastError(info, dwError);
		ShowError("Can't read from port buffer.", dwError);
		delete[] bData;
		return;
	}

	bData[dwCount] = 0;

	// Show tha data that was read
	m_sString = (PCHAR)bData;
	UpdateData(false);

	// Show the number of bytes read
	CString s;
	s.Format("%d symbols have been read from port buffer", m_sString.GetLength());
	info.Format("%d symbols have been read from COM%d port buffer", m_sString.GetLength(), port);
	Logging(info);
	MessageBox(s);

	delete[] bData;
}

// Write str button clicked
void CAvsdApiTestDlg::OnBnClickedBtnWriteStr()
{
	UpdateData();
	// Get the data to write
	PBYTE bData = (PBYTE)m_sString.GetBuffer(m_sString.GetLength()+1);
	DWORD dwWritten;
	int port = GetPlugPort();
	CString info;

	// Write data to specified port buffer
	if( !avsdWriteToPortBuffer(port, bData, m_sString.GetLength(),&dwWritten) )
	{
		DWORD dwError = ::GetLastError();
		info.Format("Can't write to COM%d port buffer:", port);
		LoggingLastError(info, dwError);
		ShowError("Can't write to port buffer.", dwError);
		return;
	}

	// Indicate the number of bytes read
	CString s;
	s.Format("%d symbols have been written to port buffer", dwWritten);
	info.Format("%d symbols have been written to COM%d port buffer", dwWritten, port);
	Logging(info);
	MessageBox(s);
}

// Clear button clicked
void CAvsdApiTestDlg::OnBnClickedBtnEventslogClear()
{
	// Clear events log
	m_sEventLog = "";
	m_edtEventsLog.SetWindowText(m_sEventLog);
}

// About button clicked
void CAvsdApiTestDlg::OnBnClickedBtnAbout()
{
	CAboutDlg dlgAbout;
	dlgAbout.DoModal();
}

// This function is called by DataEventThread when Data event is signalled
void CAvsdApiTestDlg::OnDataEvent()
{
	CString s,tmp;
	DWORD dwPort = m_EventPort;
	DWORD dwBytes;

	// Get the number of bytes in port buffer
	avsdGetNumBytesInBuffer(dwPort,&dwBytes);

	// Put string to event log
	tmp.Format("COM%d: Data event signalled. Bytes in buffer: %d\r\n",dwPort,dwBytes);
	s += tmp;
	m_sEventLog += s;
	m_edtEventsLog.SetWindowText(m_sEventLog);
}

// This function is called by SettingsEventThread when Settings event is signalled
void CAvsdApiTestDlg::OnSettingsEvent()
{
	CString s,tmp;
	DWORD dwPort = m_EventPort;
	AVSD_PORT_SETTINGS Settings;

	// Read port settings
	avsdGetSettings(dwPort,&Settings);

	// Put settings to log
	tmp.Format("COM%d: Settings event signalled.\r\n",dwPort);
	s += tmp;

	tmp = "";
	PortSettingsToStr(&Settings,&tmp);

	s += tmp;
	s += "\r\n";

	m_sEventLog += s;

	m_edtEventsLog.SetWindowText(m_sEventLog);
}

// This function is called by FlowEventThread when Flow event is signalled
void CAvsdApiTestDlg::OnFlowEvent()
{
	CString s,tmp;
	DWORD dwPort = m_EventPort;
	DWORD Signals;

	// Read the control signals states
	avsdGetControlSignals(dwPort,&Signals);

	// Put to log
	tmp.Format("COM%d: Signals = 0x%08X\r\n",dwPort,Signals);
	s += tmp;
	m_sEventLog += s;
	m_edtEventsLog.SetWindowText(m_sEventLog);
}

// This function is called by StateEventThread when OpenClose event is signalled
void CAvsdApiTestDlg::OnStateEvent()
{
	CString s,tmp;
	DWORD dwPort = m_EventPort;
	BOOL Opened;

	// Get the port state
	avsdIsPortOpened(dwPort,&Opened);
	
	// Put to log
	tmp.Format("COM%d: ",dwPort);

	if( Opened ) tmp += "Opened\r\n"; else tmp += "Closed\r\n";

	s += tmp;

	m_sEventLog += s;

	m_edtEventsLog.SetWindowText(m_sEventLog);
}

// Data event monitoring thread
// Context - pointer to CAvsdApiTestDlg
UINT CAvsdApiTestDlg::DataEventThread(LPVOID Context)
{
	CAvsdApiTestDlg *Class = (CAvsdApiTestDlg *)Context;
	while( !Class->bStopDataEventThread )
	{
		if( WaitForSingleObject(Class->m_hDataEvent,100) == WAIT_OBJECT_0 )
		{
			Class->OnDataEvent();
		}
	}
	return 0;
}

// Settings event monitoring thread
// Context - pointer to CAvsdApiTestDlg
UINT CAvsdApiTestDlg::SettingsEventThread(LPVOID Context)
{
	CAvsdApiTestDlg *Class = (CAvsdApiTestDlg *)Context;
	while( !Class->bStopSettingsEventThread )
	{
		if( WaitForSingleObject(Class->m_hSettingsEvent,100) == WAIT_OBJECT_0 )
		{
			Class->OnSettingsEvent();
		}
	}
	return 0;
}

// Flow event monitoring thread
// Context - pointer to CAvsdApiTestDlg
UINT CAvsdApiTestDlg::FlowEventThread(LPVOID Context)
{
	CAvsdApiTestDlg *Class = (CAvsdApiTestDlg *)Context;
	while( !Class->bStopFlowEventThread )
	{
		if( WaitForSingleObject(Class->m_hFlowEvent,100) == WAIT_OBJECT_0 )
		{
			Class->OnFlowEvent();
		}
	}
	return 0;
}

// OpenClose event monitoring thread
// Context - pointer to CAvsdApiTestDlg
UINT CAvsdApiTestDlg::StateEventThread(LPVOID Context)
{
	CAvsdApiTestDlg *Class = (CAvsdApiTestDlg *)Context;
	while( !Class->bStopStateEventThread )
	{
		if( WaitForSingleObject(Class->m_hStateEvent,100) == WAIT_OBJECT_0 )
		{
			Class->OnStateEvent();
		}
	}
	return 0;
}

// Apply button clicked.
// Applies event monitoring options.
void CAvsdApiTestDlg::OnEventsApply() 
{
	UpdateData();

	DWORD dwPort = GetEventsPort();

	// Stop all threads
	bStopFlowEventThread = TRUE;
	bStopDataEventThread = TRUE;
	bStopStateEventThread = TRUE;
	bStopSettingsEventThread = TRUE;

	// Clear thead pointers
	m_pDataThread = NULL;
	m_pSettingsThread = NULL;
	m_pFlowThread = NULL;
	m_pStateThread = NULL;

	// Wait while threads complete
	Sleep(500);

	// Close all events if they were opened
	if(m_hDataEvent) CloseHandle(m_hDataEvent);
	if(m_hSettingsEvent) CloseHandle(m_hSettingsEvent);
	if(m_hFlowEvent) CloseHandle(m_hFlowEvent);
	if(m_hStateEvent) CloseHandle(m_hStateEvent);

	// Clear event handles
	m_hDataEvent = NULL;
	m_hSettingsEvent = NULL;	
	m_hFlowEvent = NULL;
	m_hStateEvent = NULL;

	// Save the new port number
	m_EventPort = dwPort;

	// State Change checkbox
	if(m_arrChEvents[0].GetCheck() == BST_CHECKED)
	{
		// Get the OpenCLose event handle
		m_hStateEvent = avsdGetOpenCloseEvent(dwPort);
		bStopStateEventThread = FALSE;
		// Start event monitoring thread
		m_pStateThread = AfxBeginThread(StateEventThread,this);
	}

	//Settings Change checkbox
	if(m_arrChEvents[1].GetCheck() == BST_CHECKED)
	{
		// Get the Settings event handle
		m_hSettingsEvent = avsdGetSettingsEvent(dwPort);
		bStopSettingsEventThread = FALSE;
		// Start event monitoring thread
		m_pSettingsThread = AfxBeginThread(SettingsEventThread,this);
	}

	// Buffer Data checkbox
	if(m_arrChEvents[2].GetCheck() == BST_CHECKED)
	{
		// Get the Data event handle
		m_hDataEvent = avsdGetDataEvent(dwPort);
		bStopDataEventThread = FALSE;
		// Start event monitoring thread
		m_pDataThread = AfxBeginThread(DataEventThread,this);
	}

	// Control signals change checkbox
	if(m_arrChEvents[3].GetCheck() == BST_CHECKED)
	{
		// Get the Flow event handle
		m_hFlowEvent = avsdGetFlowEvent(dwPort);
		bStopFlowEventThread = FALSE;
		// Start event monitoring thread
		m_pFlowThread = AfxBeginThread(FlowEventThread,this);
	}
}
void CAvsdApiTestDlg::OnOpenPort()
{
	int port = GetPlugPort();
	CString s;

	if (handles[port-1] == NULL)
	{
		s.Format("\\\\.\\COM%d", port);
		HANDLE h = CreateFile(s, GENERIC_ALL,
			FILE_SHARE_READ | FILE_SHARE_WRITE, NULL, OPEN_EXISTING, 0, 0);
		if (h == INVALID_HANDLE_VALUE)
		{
			s.Format("Open COM%d FAILED:", port);
			LoggingLastError(s, ::GetLastError());
		}
		else
		{
			handles[port-1] = h;
			s.Format("COM%d opened SUCCESS", port);
			Logging(s);
		}
	}
	else
	{
		s.Format("COM%d opened already", port);
		Logging(s);
	}
}

void CAvsdApiTestDlg::OnCloseCOM()
{
	int port = GetPlugPort();
	CString s;

	if (handles[port-1] != NULL)
	{
		CloseHandle(handles[port-1]);
		handles[port-1] = NULL;
		s.Format("COM%d closed.", port);
	}
	else
	{
		s.Format("COM%d not opened", port);
	}

	Logging(s);
}

void CAvsdApiTestDlg::OnWriteCOM()
{
	int port = GetPlugPort();
	CString s;

	if (handles[port-1] != NULL)
	{
		DWORD dwWritten;
		BOOL bRes = WriteFile(handles[port-1], m_sStringCOM, m_sStringCOM.GetLength(), &dwWritten, NULL);
		if (bRes == TRUE)
		{
			s.Format("Write %d bytes to COM%d SUCCESS", dwWritten, port);
			Logging(s);
		}
		else
		{
			s.Format("Write to COM%d FAILED:", port, ::GetLastError());
			Logging(s);
		}
	}
	else
	{
		s.Format("COM%d not opened", port);
		Logging(s);
	}
}

void CAvsdApiTestDlg::OnReadCOM()
{
	int port = GetPlugPort();
	CString s;

	m_sStringCOM = "";

	if (handles[port-1] != NULL)
	{
		DWORD dwRead;
		char buf[1024+1];
		BOOL bRes = ReadFile(handles[port-1], buf, 3/*1024*/, &dwRead, NULL);
		if (bRes == TRUE)
		{
			buf[dwRead] = 0; //EOL
			m_sStringCOM = CString(buf);
			s.Format("Read %d bytes from COM%d SUCCESS", dwRead, port);
			Logging(s);
		}
		else
		{
			s.Format("Read from COM%d FAILED:", port, ::GetLastError());
			Logging(s);
		}
	}
	else
	{
		s.Format("COM%d not opened", port);
		Logging(s);
	}

	UpdateData(false);
}
